// Program 5. Basic JPEG algorithm implementation
//Software version
//OS Windows7
//Scilab5.4.1
//Image Processing Design Toolbox 8.3.1-1
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2
close
clear;
clc;
exec('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\zigzag_5.sci')
exec('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\izigzag_5.sci')
I = imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\cameraman.jpeg'); //256x256 image
I = imresize(I,0.25);//reduced to 64x64 image [in order to reduce the computation time]
[m,n]=size(I);// Finding the dimensions of the image file.
I=double(I);
q= [16 11 10 16 24 40 51 61;
    12 12 14 19 26 58 60 55;
    14 13 16 24 40 57 69 56;
    14 17 22 29 51 87 80 62;
    18 22 37 56 68 109 103 77;
    24 35 55 64 81 104 113 92;
    49 64 78 87 103 121 120 101;
    72 92 95 98 112 100 103 99];
N=8;                        // Block size for which DCT is Computed.
M=8;
I_Trsfrm.block=zeros(N,M);  // Initialising the DCT Coefficients Structure Matrix "I_Trsfrm" with the required dimensions.
for a=1:m/N
    for b=1:n/M
        for k=1:N
            for l=1:M
                Mean_Sum=0;
                //2D-Discrete Cosine Transform///////
                for i=1:N
                    for j=1:M
                        Mean_Sum = Mean_Sum+double(I(N*(a-1)+i,M*(b-1)+j))*cos(%pi*(k-1)*(2*i-1)/(2*N))*cos(%pi*(l-1)*(2*j-1)/(2*M));
                    end
                end
                ///////////////
                if k==1
                    Mean_Sum = Mean_Sum*sqrt(1/N);
                else
                    Mean_Sum = Mean_Sum*sqrt(2/N);
                end
                if l==1
                    Mean_Sum = Mean_Sum*sqrt(1/M);
                else
                    Mean_Sum = Mean_Sum*sqrt(2/M);
                end
                I_Trsfrm(a,b).block(k,l)= Mean_Sum;
            end
        end
        // Normalizing the DCT Matrix and Quantizing the resulting values.
        I_Trsfrm(a,b).block=round(I_Trsfrm(a,b).block./q);
    end
end
I_zigzag.block = zeros(N,M);
for a= 1:m/N
    for b = 1:n/M
        I_zigzag(a,b).block = zigzag_5(I_Trsfrm(a,b).block);
    end
end
I_rec_Trnsfm.block = zeros(N,M);
for a= 1:m/N
    for b = 1:n/M
        I_rec_Trnsfm(a,b).block = izigzag_5(I_zigzag(a,b).block);
    end
end 
// Denormalizing the Reconstructed Tranform matrix using the same
// Normalization matrix.
for a=1:m/N
    for b=1:n/M
        I_rec_Trnsfm(a,b).block =(I_rec_Trnsfm(a,b).block).*q;
    end
end
//Inverse 2D-DCT
for a=1:m/N
    for b=1:n/M
        for i=1:N
            for j=1:M
                Mean_Sum =0;
                for k=1:N
                    for l=1:M
                        if k==1
                           temp =double(sqrt(1/2)*I_rec_Trnsfm(a,b).block(k,l))*cos(%pi*(k-1)*(2*i-1)/(2*N))*cos(%pi*(l-1)*(2*j-1)/(2*M));
                        else
                            temp = double(I_rec_Trnsfm(a,b).block(k,l))*cos(%pi*(k-1)*(2*i-1)/(2*N))*cos(%pi*(l-1)*(2*j-1)/(2*M));
                        end
                        if l==1
                            temp = temp*sqrt(1/2);
                        end
                        Mean_Sum = Mean_Sum+temp;
                    end
                end
                Mean_Sum = Mean_Sum*(2/sqrt(M*N));
                I_rec((a-1)*N+i,(b-1)*M+j)= Mean_Sum;
            end
        end
    end
end
// Displaying the Reconstructed Image.
diff_image = im2double(I)*255-I_rec;
diff_image = diff_image/max(max(diff_image));
diff_image = im2uint8(diff_image);
I_rec = I_rec/max(max(I_rec));
I_rec = im2uint8(I_rec);
figure
ShowImage(I_rec,'Recovered Image');
figure
ShowImage(diff_image,'Difference Image')
figure
imhist(I_rec);
figure
imhist(diff);
